import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import EmberObject from 'ember-object';
import hbs from 'htmlbars-inline-precompile';
import run from 'ember-runloop';
import RSVP from 'rsvp';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import { assign } from 'ember-platform';

const TOKEN = 'foobar';
const OauthSession = AuthenticatedSession.extend({
  userData: assign({chat_oauth_token: TOKEN}, AuthenticatedSession.prototype.userData),
  getOAuthToken() {
    return RSVP.resolve(TOKEN);
  }
});

let rawEmoteSet;

moduleForComponent('twitch-feed/comments', 'Integration | Component | twitch-feed/comments', {
  integration: true,

  beforeEach() {
    let store = this.container.lookup('service:store');
    let [ user, post, comment ] = store.push({
      data: [
        {
          id: 'u1',
          type: 'feed-user',
          attributes: {
            login: 'twitch'
          }
        },
        {
          id: 'p1',
          type: 'post',
          attributes: {
            body: 'Hello World'
          },
          relationships: {
            user: { data: { type: 'feed-user', id: 'u1' } }
          }
        },
        {
          id: 'c1',
          type: 'comment',
          attributes: {
            body: 'Best comment ever',
            reactions: []
          },
          relationships: {
            user: { data: { id: 'u1', login: 'u1', type: 'feed-user' } },
            post: { data: { id: 'p1', type: 'post'} }
          }
        }
      ]
    });

    comment.get('reactions').pushObject(EmberObject.create({
      emoteId: 'endorse',
      emoteName: 'endorse',
      count: 0,
      userIds: []
    }));

    rawEmoteSet = {"emoticon_sets":{"0":[{"id":166,"code":"Volcania"}]}};
    this.register('service:session', OauthSession);
    this.inject.service('feeds');
    this.set('feeds.meAsFeedUser', user);
    this.setProperties({ post, comment, user, rawEmoteSet });
  }
});

test('Additionally loaded comments are rendered properly', function (assert) {
  assert.expect(2);
  let comments = [this.get('comment')];
  let additionalComments = [
    EmberObject.create({body: 'Great comment'})
  ];
  this.set('commentsTotal', comments.length + additionalComments.length);
  this.set('comments', comments);
  this.render(hbs`{{twitch-feed/comments
    comments=comments
    postId=post.id
    commentsTotal=commentsTotal
  }}`);

  assert.equal(this.$('.activity-comment').length, comments.length, 'Correct number of comments are initially rendered');
  run(() => {
    comments.pushObjects(additionalComments);
  });
  assert.equal(this.$('.activity-comment').length, comments.length, 'New comments are rendered properly');
});
