import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import ChannelPage from '../../../pages/channel-feed';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

let channelName = 'twitch';
let page;

moduleForComponent('twitch-feed/composer', 'Integration | Component | twitch-feed/composer', {
  integration: true,

  beforeEach() {
    page = ChannelPage.create({ name: channelName });
  }
});

test('can add an emote to the composer textarea using the emote selector', function (assert) {
  assert.expect(2);
  let rawEmoteSet = {"emoticon_sets":{"0":[{"id":166,"code":"Volcania"}]}};
  this.render(hbs`{{twitch-feed/composer
    rawEmoteSet=rawEmoteSet
    showEmoticonSelector=true
  }}`);
  this.set('rawEmoteSet', rawEmoteSet);

  let emoteName = rawEmoteSet.emoticon_sets[0][0].code;
  let emoteSelection = this.$('.emoticon.tooltip');
  let composerTextarea = this.$(page.feedTextarea);

  assert.equal(composerTextarea.val().trim(), '', 'Composer textarea is empty');
  emoteSelection.click();

  assert.equal(composerTextarea.val().trim(), emoteName, 'Emote name successfully added to the textarea');
});

test('live embed shows up in composer', function (assert) {
  assert.expect(1);
  this.render(hbs`{{twitch-feed/composer
    messageText="test post https://clips.twitch.tv/odpixel/BusyNewtNotLikeThis"
    liveEmbed=true
  }}`);
  let event = $.Event('keydown', {keyCode: 32});
  this.$(page.feedTextarea).trigger(event);

  return wait().then(() => {
    let embedLayout = this.$('.card__layout');
    assert.elementCount(embedLayout, 1, 'embed rendered');
  });
});
