import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import ChannelPage from '../../../pages/channel-feed';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import RSVP from 'rsvp';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import { assign } from 'ember-platform';

const TOKEN = 'foobar';
const OauthSession = AuthenticatedSession.extend({
  userData: assign({chat_oauth_token: TOKEN}, AuthenticatedSession.prototype.userData),
  getOAuthToken() {
    return RSVP.resolve(TOKEN);
  }
});

let channelName = 'twitch';
let page;

moduleForComponent('twitch-feed/controls', 'Integration | Component | twitch-feed/controls', {
  integration: true,

  beforeEach() {
    page = ChannelPage.create({ name: channelName });

    let store = this.container.lookup('service:store');
    let [ user, post, comment ] = store.push({
      data: [
        {
          id: 'u1',
          type: 'feed-user',
          attributes: {
            login: 'twitch'
          }
        },
        {
          id: 'p1',
          type: 'post',
          attributes: {
            body: 'Hello World',
            permissions: {
              can_moderate: true,
              can_reply: true,
              can_delete: true
            }
          },
          relationships: {
            user: { data: { type: 'feed-user', id: 'u1' } }
          }
        },
        {
          id: 'c1',
          type: 'comment',
          attributes: {
            body: 'Best comment ever'
          },
          relationships: {
            user: { data: { id: 'u1', login: 'u1', type: 'feed-user' } },
            post: { data: { id: 'p1', type: 'post'} }
          }
        }
      ]
    });
    this.register('service:session', OauthSession);
    this.setProperties({ user, post, comment });
  }
});

test('Post URL passes through to share menu', function (assert) {
  assert.expect(1);
  let expectedUrl = `${location.protocol}//${location.hostname}:${location.port}/${channelName}/p/${this.get('post.id')}`;
  this.on('deleteAction', () => this);
  this.render(hbs`{{twitch-feed/controls message=post post=post deleteAction=(action 'deleteAction')}}`);

  this.$(page.postModControls).click();
  this.$(page.sharePostMenu).click();
  this.$(page.confirmSharePost).click();
  let renderedUrl = $(page.sharePostUrl).val();

  assert.ok(renderedUrl.indexOf(expectedUrl) > -1, 'The post URL renders properly.');

  return wait();
});

test('can report a post', function (assert) {
  assert.expect(1);
  this.on('deleteAction', () => this);
  this.render(hbs`{{twitch-feed/controls message=post post=post reportReason='selfharm' deleteAction=(action 'deleteAction')}}`);

  this.$(page.postModControls).click();
  this.$(page.reportPostMenu).show();
  this.$(page.confirmReportPost).click();
  return wait().then(() => {
    assert.ok(this.$('.js-controls').hasClass('hide'), 'Post was reported');
  });
});

test('Can delete a post', function (assert) {
  assert.expect(1);
  this.on('deleteAction', () => {
    assert.ok(true, 'delete action called');
    return RSVP.resolve();
  });

  this.render(hbs`{{twitch-feed/controls message=post post=post deleteAction=(action 'deleteAction')}}`);

  this.$(page.postModControls).click();
  this.$(page.deletePostMenu).click();
  this.$(page.confirmDeletePost).click();
  return wait();
});
