import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import EmberObject from 'ember-object';
import ChannelPage from '../../../pages/channel-feed';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import run from 'ember-runloop';

const NUM_TOP_REACTIONS = 4;
let channelName = 'twitch';
let page;

moduleForComponent('twitch-feed/reactions', 'Integration | Component | twitch-feed/reactions', {
  integration: true,

  beforeEach() {
    page = ChannelPage.create({ name: channelName });

    let store = this.container.lookup('service:store');
    let [ post, comment ] = store.push({
      data: [
        {
          id: 'u1',
          type: 'feed-user',
          attributes: {
            login: 'twitch'
          }
        },
        {
          id: 'p1',
          type: 'post',
          attributes: {
            body: 'Hello World',
            reactions: []
          },
          relationships: {
            user: { data: { type: 'feed-user', id: 'u1' } }
          }
        },
        {
          id: 'c1',
          type: 'comment',
          attributes: {
            body: 'Best comment ever'
          },
          relationships: {
            user: { data: { id: 'u1', login: 'u1', type: 'feed-user' } },
            post: { data: { id: 'p1', type: 'post'} }
          }
        }
      ]
    });
    let rawEmoteSet = {};

    let reactions = [
      EmberObject.create({count: 0, emoteId: 'endorse', emoteName: 'endorse', userIds: []})
    ];

    this.setProperties({ post, comment, rawEmoteSet, reactions });
  }
});

test('can add a reaction to a set of reactions', function (assert) {
  assert.expect(2);
  let reactions = this.get('reactions');
  this.render(hbs`{{twitch-feed/reactions reactions=reactions rawEmoteSet=rawEmoteSet}}`);
  
  assert.equal(this.$(page.reactButton).length, reactions.length, 'The correct number of reactions render');

  let reaction = EmberObject.create({count: 1, emoteId: 25, emoteName: 'Kappa', userIds: []});
  run(() => {
    reactions.pushObject(reaction);
  });
  
  assert.equal(this.$(page.reactButton).length, reactions.length, 'A new reaction is rendered when added to the reactions array');
});

test('can view the reactions overflow window', function (assert) {
  assert.expect(3);
  let reactions = this.get('reactions');
  let additionalReactions = [
    EmberObject.create({count: 1, emoteId: 25, emoteName: 'Kappa', userIds: []}),
    EmberObject.create({count: 1, emoteId: 25, emoteName: 'Kappa', userIds: []}),
    EmberObject.create({count: 1, emoteId: 25, emoteName: 'Kappa', userIds: []}),
    EmberObject.create({count: 1, emoteId: 25, emoteName: 'Kappa', userIds: []})
  ];
  reactions.pushObjects(additionalReactions);
  this.render(hbs`{{twitch-feed/reactions reactions=reactions rawEmoteSet=rawEmoteSet}}`);

  assert.ok(this.$('.js-reactions-menu')[0], 'Reaction overflow button is present');

  this.$('.js-reactions-menu button').click();

  assert.ok(this.$('.js-reactions-menu .balloon')[0], 'Reaction overflow menu can be opened');
  assert.equal(this.$('.js-reactions-menu .balloon li').length, reactions.length - NUM_TOP_REACTIONS, 'The correct number of reactions are in the overflow menu');
});

test('UI updates after endorsing a reaction', function (assert) {
  assert.expect(2);
  let reaction = this.get('reactions')[0];
  this.set('onReaction', () => {
    reaction.set('userIds', ['u1']);
  });
  this.render(hbs`{{twitch-feed/reactions reactions=reactions rawEmoteSet=rawEmoteSet onReaction=onReaction}}`);
  
  let endorseReaction = this.$('.activity-button:eq(0)');
  assert.ok(endorseReaction, 'The endorse reaction renders');
  endorseReaction.click();
  assert.ok(endorseReaction.hasClass('activity-button--selected'), 'Reaction UI updated properly');
});
