import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import $ from 'jquery';
import { IS_HOVERING_CLASS } from 'web-client/components/file-drop-zone';

moduleForComponent('file-drop-zone');

test('toggling classes on dragover and dragleave', function(assert) {
  this.render(hbs`{{file-drop-zone id="subject"}}`);
  let el = this.$('#subject');

  assert.equal(el.hasClass(IS_HOVERING_CLASS), false, 'has no active class at first');
  el.trigger('dragover');
  assert.equal(el.hasClass(IS_HOVERING_CLASS), true, 'has active class when hovering with files');
  el.trigger('dragleave');
  assert.equal(el.hasClass(IS_HOVERING_CLASS), false, 'has no active class when hovering stops');
});

test('toggling classes on dragover and drop', function(assert) {
  this.render(hbs`{{file-drop-zone id="subject"}}`);
  let el = this.$('#subject');

  assert.equal(el.hasClass(IS_HOVERING_CLASS), false, 'has no active class at first');
  el.trigger('dragover');
  assert.equal(el.hasClass(IS_HOVERING_CLASS), true, 'has active class when hovering with files');
  el.trigger(createDropEvent({ files: ['dummy'] }));
  assert.equal(el.hasClass(IS_HOVERING_CLASS), false, 'has no active class when file is dropped');
});

test('dropping a file', function(assert) {
  let droppedFile;
  this.set('onFileDrop', function(file) {
    droppedFile = file;
  });

  this.render(hbs`{{file-drop-zone id="subject" onFileDrop=onFileDrop}}`);
  let el = this.$('#subject');

  el.trigger(createDropEvent({ files: ['dummy'] }));

  assert.equal(droppedFile, 'dummy', 'onFileDrop called with file');
});

function createDropEvent(dataTransfer) {
  return $.Event('drop', { dataTransfer });
}
