import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { SORT_PERIOD_DAY } from 'web-client/adapters/clip';
import { TEST_SELECTOR, DROPDOWN_TEST_SELECTOR } from 'web-client/components/filter-bar/filters/clips-sort/component';
import { TEST_SELECTOR as OPTION_SELECTOR } from 'web-client/components/clips/clips-sort-option/component';

moduleForComponent('filter-bar/filters/clips-sort', 'Integration | Component | clips-sort', {
  integration: true,
  beforeEach() {
    this.set('selectedSortOption', SORT_PERIOD_DAY);

    this.defaultTemplate = hbs`{{filter-bar/filters/clips-sort selectedSortOption=selectedSortOption}}`;
    this.testSelector = `[data-test-selector="${TEST_SELECTOR}"]`;
    this.dropdownTestSelector = `[data-test-selector="${DROPDOWN_TEST_SELECTOR}"]`;
    this.sortOptionSelector = `[data-test-selector="${OPTION_SELECTOR}"]`;
    this.dropdownTogglingOptionSelector = `${this.testSelector} > :first`;
  }
});

test('on initial render', function(assert) {
  assert.expect(2);
  this.render(this.defaultTemplate);

  assert.elementCount(`${this.dropdownTestSelector}.hide`, 1, 'dropdown is hidden');
  assert.elementText(`${this.sortOptionSelector}:first`, /Top 24h/, 'renders selected sort option');
});

test('selected sort option', function(assert) {
  assert.expect(3);
  this.render(this.defaultTemplate);

  $(this.dropdownTogglingOptionSelector).click();
  assert.elementCount(`${this.dropdownTestSelector}.show`, 1, 'shows dropdown on click');
  assert.elementCount(`${this.dropdownTestSelector} ${this.sortOptionSelector}`, 5, 'dropdown has sort options');

  $(this.dropdownTogglingOptionSelector).click();
  assert.elementCount(`${this.dropdownTestSelector}.hide`, 1, 'hides dropdown on click if dropdown was open');
});

test('on click outside', function(assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);
  this.$(this.dropdownTogglingOptionSelector).click();

  $(document).click();
  assert.elementCount(`${this.dropdownTestSelector}.hide`, 1, 'hides dropdown');
});
