import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import MockTrackingService from 'web-client/tests/helpers/mock-tracking-service';

moduleForComponent('filter-bar/filters/video-sort', 'Integration | Component | filter-bar/filters/video-sort', {
  integration: true,
  beforeEach() {
    this.register('service:tracking', MockTrackingService);
    this.inject.service('tracking', {as: 'trackingService'});
  }
});

test('it renders', function(assert) {
  this.set('selectedSort', 'views');
  this.set('siblings', ['time', 'views']);

  this.render(hbs`{{filter-bar/filters/video-sort selectedSort=selectedSort siblings=siblings}}`);
  assert.equal($('.js-vod-filter').length, 1);
  assert.equal(this.$().text().trim().split(' ')[0].trim(), 'Popular');
  assert.equal($('.balloon__link').text().trim().split(/\s+/)[0], 'Recent');
  assert.equal($('.balloon__link').text().trim().split(/\s+/)[1], 'Popular');
  assert.equal($('.filter-bar__balloon-link--active').length, 1);
});

test('it changes and fires an event on click', function(assert) {
  assert.expect(10);
  this.set('selectedSort', 'views');
  this.set('siblings', ['time', 'views']);
  this.set('changeSort', function(sortType) {
    this.set('selectedSort', 'time');
    assert.equal(sortType, 'time');
  });

  this.render(hbs`{{filter-bar/filters/video-sort selectedSort=selectedSort siblings=siblings changeSort=(action changeSort)}}`);
  assert.equal(this.get('trackingService')._invocations.length, 1);
  assert.equal(this.get('trackingService')._invocations[0].event, 'sort_type_action');
  assert.equal(this.get('trackingService')._invocations[0].data.sorting_type, 'views');
  assert.equal($('.filter-bar__balloon-link--active').length, 1);

  this.$('.balloon__link:first').click();
  assert.equal(this.$().text().trim().split(' ')[0].trim(), 'Recent');
  assert.equal(this.get('trackingService')._invocations.length, 2);
  assert.equal(this.get('trackingService')._invocations[1].event, 'sort_type_action');
  assert.equal(this.get('trackingService')._invocations[1].data.sorting_type, 'time');
  assert.equal($('.filter-bar__balloon-link--active').length, 1);
});
