import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import MockTrackingService from 'web-client/tests/helpers/mock-tracking-service';

moduleForComponent('filter-bar/filters/video-type', 'Integration | Component | filter-bar/filters/video-type', {
  integration: true,
  beforeEach() {
    this.register('service:tracking', MockTrackingService);
    this.inject.service('tracking', {as: 'trackingService'});
  }
});

test('it renders', function(assert) {
  this.set('selectedType', 'uploads');
  this.set('siblings', ['uploads', 'highlights']);

  this.render(hbs`{{filter-bar/filters/video-type selectedNavigationItem=selectedType siblings=siblings}}`);
  assert.equal($('.js-vod-filter').length, 1);
  assert.equal(this.$().text().trim().split(' ')[0].trim(), 'Uploads');
  assert.equal($('.balloon__link').text().trim().split(/\s+/)[0], 'Uploads');
  assert.equal($('.balloon__link').text().trim().split(/\s+/)[1], 'Highlights');
});

test('it fires an event on click', function(assert) {
  // testing that this changes is difficult because it involves a route change
  assert.expect(6);
  this.set('selectedType', 'uploads');
  this.set('siblings', ['highlights', 'uploads']);

  // there should be an event fired when it renders
  this.render(hbs`{{filter-bar/filters/video-type selectedNavigationItem=selectedType siblings=siblings}}`);
  assert.equal(this.get('trackingService')._invocations.length, 1);
  assert.equal(this.get('trackingService')._invocations[0].event, 'vod_type_filter_action');
  assert.equal(this.get('trackingService')._invocations[0].data.vod_type, 'uploads');

  this.$('.balloon__link:first').click();
  assert.equal(this.get('trackingService')._invocations.length, 2);
  assert.equal(this.get('trackingService')._invocations[1].event, 'vod_type_filter_action');
  assert.equal(this.get('trackingService')._invocations[1].data.vod_type, 'highlights');
});
