import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('front-page/announcement-loader', 'Integration | Component | front page/announcement loader');

test('renders twitch prime announcement with feature on', function(assert) {
  this.render(hbs`{{front-page/announcement-loader}}`);

  assert.elementCount(this.$('.front-page-announcement'), 1, 'displays twitch prime announcement');
});

test('renders social media when user has prime', function(assert) {
  let session = {
    userData: {
      has_premium: true
    }
  };
  this.set('session', session);
  this.render(hbs`{{front-page/announcement-loader session=session}}`);

  assert.elementCount(this.$('#social-media'), 1, 'with prime displays social-media component ');
});
