import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

const FEATURED_STREAMS = [{
  'featured_image': 'image1.jpg',
  game: 'Counter Strike',
  schedule: false,
  channel: {
    'display_name': 'Day9tv',
    name: 'day9tv'
  }
}, {
  'featured_image': 'image2.jpg',
  game: 'Starcraft',
  schedule: true,
  channel: {
    'display_name': 'WhiteRa',
    name: 'whitera'
  }
}];

moduleForComponent('front-page/carousel-menu', 'Integration | Component | front page/carousel menu');

test('it sets class="active" on the selected stream', function(assert) {
  assert.expect(1);
  this.set('featuredStreams', FEATURED_STREAMS);
  this.set('selectedIndex', 0);
  this.render(hbs`{{front-page/carousel-menu
    featuredStreams=featuredStreams
    selectedIndex=selectedIndex}}`);
  let $first = this.$('li:nth-child(1)');
  assert.ok($first.hasClass('active'), 'first stream has class="active"');
});

test('it sends a frontpage-carousel-click event to Mixpanel when changing streams', function(assert) {
  assert.expect(1);
  this.set('featuredStreams', FEATURED_STREAMS);
  this.render(hbs`{{front-page/carousel-menu featuredStreams=featuredStreams}}`);
  this.$('li:nth-child(2) a').click();

  assert.trackEvent('frontpage-carousel-click', {
    'carousel_index': 1,
    'promotion_was_scheduled': true,
    channel: 'whitera',
    game: 'Starcraft'
  });
});

test('changing selectedIndex changes .active class', function(assert) {
  assert.expect(3);

  this.set('featuredStreams', FEATURED_STREAMS);
  this.set('selectedIndex', 0);

  this.render(hbs`{{front-page/carousel-menu
    selectedIndex=selectedIndex
    featuredStreams=featuredStreams}}`);

  let $stream1 = this.$('li.js-carousel-nav:nth-child(1)');
  assert.ok($stream1.length, 'first stream is active');

  this.set('selectedIndex', 1);

  let $stream2 = this.$('li.js-carousel-nav:nth-child(2)');
  assert.ok(!$stream1.hasClass('active'), 'first stream is not active');
  assert.ok($stream2.length, 'second stream is active');
});
