import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { stubLogin } from '../../../helpers/stub-login';

moduleForComponent('front-page/header-bar', 'Integration | Component | front page/header bar', {

  beforeEach() {
    this.inject.service('premium-geo');

    this.get('premium-geo').set('isPrimeGeo', true);
  }
});

test("Displays Go Turbo button if not logged in and user isn't in a Prime geo", function(assert) {
  this.get('premium-geo').set('isPrimeGeo', false);

  this.render(hbs`
    <div id="wormhole-overlays"></div>
    {{front-page/header-bar}}
  `);

  assert.elementText(this.$('[data-header-bar-upsell]'), "Go Turbo");
});

test("Displays Go Turbo button if logged in and user isn't in a Prime geo and user does not have Turbo", function(assert) {
  this.get('premium-geo').set('isPrimeGeo', false);

  stubLogin({
    has_turbo: false
  });

  this.render(hbs`
    <div id="wormhole-overlays"></div>
    {{front-page/header-bar}}
  `);

  assert.elementText(this.$('[data-header-bar-upsell]'), "Go Turbo");
});

test("Displays Try Prime button if not logged in and user is in a Prime geo", function(assert) {
  this.get('premium-geo').set('isPrimeGeo', true);

  this.render(hbs`
    <div id="wormhole-overlays"></div>
    {{front-page/header-bar}}
  `);

  assert.elementText(this.$('[data-header-bar-upsell]'), "Try Twitch Prime");
});

test("Displays Try Prime button if logged in and user is in a Prime geo and user does not have Prime", function(assert) {
  this.get('premium-geo').set('isPrimeGeo', true);
  stubLogin({
    has_premium: true
  });

  this.render(hbs`
    <div id="wormhole-overlays"></div>
    {{front-page/header-bar}}
  `);

  assert.elementText(this.$('[data-header-bar-upsell]'), "Try Twitch Prime");
});
