import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import $ from 'jquery';

moduleForComponent('front-page/header-username-menu', 'Integration | Component | front-page/header-username-menu');

test('displays a clickable username', function(assert) {
  assert.expect(1);
  stubLogin({ login: 'test-twitch-user' });
  this.render(hbs`{{front-page/header-username-menu}}`);
  let username = this.$('#user_display_name').text().trim();
  assert.equal(username, 'test-twitch-user');
});

test('displays an extended menu upon clicking the username', function(assert) {
  assert.expect(2);
  let isMenuPresent = () => this.$('#self_actions').length > 0;
  this.render(hbs`{{front-page/header-username-menu}}`);
  assert.notOk(isMenuPresent(), 'menu is not present upon initial load');
  this.$('#user_display_name').click();
  assert.ok(isMenuPresent(), 'menu appears after clicking');
});

test('closes when clicking outside the modal', function(assert) {
  assert.expect(2);
  let isMenuPresent = () => this.$('#self_actions').length > 0;
  this.render(hbs`{{front-page/header-username-menu}}`);
  this.$('#user_display_name').click();
  assert.ok(isMenuPresent(), 'menu is present at start');
  $('body').click(); // click anywhere outside.
  assert.notOk(isMenuPresent(), 'menu closes after clicking outside');
});
