import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import FrontPage from 'web-client/tests/pages/index';

let page;

moduleForComponent('front-page/stream-list', 'Integration | Component | front page/stream list', {
  integration: true,
  beforeEach() {
    page = FrontPage.create();
  }
});

test('it renders live streams', function(assert) {
  assert.expect(3);

  let stream = this.server.create('stream', { name: 'live-day9tv', channelHref: '/live-day9tv'});
  this.set('streams', [stream]);

  this.render(hbs`{{front-page/stream-list streams=streams type='live'}}`);

  let title = this.$('h2').text().trim();
  let opts = page.live;
  assert.ok(opts.fullTitle.test(title), 'title');
  assert.equal(this.$(opts.streams).length, 1, '1 stream with ID set to top-channels and data attr');
  assert.ok(this.$(opts.allChannelsLink).length, 'link to all channels');
});

test('it renders ps4 streams', function(assert) {
  assert.expect(4);

  let stream = this.server.create('stream', { name: 'ps4-day9tv', channelHref: `/ps4-day9tv`});
  this.set('streams', [stream]);

  this.render(hbs`{{front-page/stream-list streams=streams type='psFour'}}`);

  let title = this.$('h2').text().trim();
  let opts = page.ps4;
  assert.ok(opts.fullTitle.test(title), 'title');
  assert.equal(this.$(opts.streams).length, 1, '1 stream with ID set to psFour-channels and data attr');
  assert.ok(this.$(opts.allChannelsLink).length, 'link to all PS4 channels');
  assert.ok(this.$(page.videoGrid).length, 'custom js-top-psFour class set');
});

test('it renders xbox streams', function(assert) {
  assert.expect(4);

  let stream = this.server.create('stream', { name: 'xbox-day9tv', channelHref: `/xbox-day9tv` });
  this.set('streams', [stream]);

  this.render(hbs`{{front-page/stream-list streams=streams type='xbox'}}`);

  let title = this.$('h2').text().trim();
  let opts = page.xbox;
  assert.ok(opts.fullTitle.test(title), 'title');
  assert.equal(this.$(opts.streams).length, 1, '1 stream with ID set to xbox-channels and data attr');
  assert.ok(this.$(opts.allChannelsLink).length, 'link to all Xbox One channels');
  assert.ok(this.$(page.videoGrid).length, 'custom js-top-xbox class set');
});
