import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

import { BASE_URL, SIZES } from 'web-client/components/game-art';

moduleForComponent('game-art', 'Integration | Component | game art');

test('it renders', function(assert) {
  let name = 'csgo';
  let size = 'small';

  this.set('name', name);
  this.set('size', size);

  let template = hbs`{{game-art name size}}`;
  this.render(template);

  let img = this.$('img');
  assert.equal(img.attr('src'), `${BASE_URL}/${name}-${SIZES[size]}.jpg`,
              'name and size are present in the img src');
});
