import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('game-select', 'Integration | Component | game-select', {
  beforeEach() {
    this.callbacks = [];

    this.set('didBeginSearch', game => {
      this.callbacks.push(['didBeginSearch', game]);
    });

    this.set('didResolveGame', game => {
      this.callbacks.push(['didResolveGame', game]);
    });
  }
});

test('Render the game select', function(assert) {
  assert.expect(3);

  let inputClass = 'form__input form__input--anim-basic';

  this.set('inputClass', inputClass);
  this.set('gameName', null);

  this.render(hbs`{{game-select gameName=gameName inputClass=inputClass}}`);

  assert.equal(this.$('input').attr('class'), inputClass, '<input> has the passed in class');
  assert.equal(this.$('input').attr('placeholder'), 'Search for a game', 'The placeholder is correct');
  assert.equal(this.$('input').val(), '', 'The input has no value');
});

test('Type a game into the game-select and finding a game', function(assert) {
  assert.expect(6);

  this.server.create('game', { name: 'Overwatch', _id: '1' });

  this.render(hbs`
    {{game-select
      gameName=null
      didBeginSearch=didBeginSearch
      didResolveGame=didResolveGame
    }}
  `);

  this.$('input').val('Overwat').trigger('input');
  assert.deepEqual(this.callbacks, [['didBeginSearch', { name: 'Overwat', id: null }]], 'immediately sends didBeginSearch');
  this.callbacks = [];

  return wait().then(() => {
    assert.deepEqual(this.callbacks, [['didResolveGame', { name: 'Overwat', id: null }]], 'later sends didResolveGame');
    this.callbacks = [];

    assert.elementCount(this.$('ul'), 1, 'list of suggested games is rendered');

    this.$('a:first').click();
    assert.deepEqual(this.callbacks, [['didResolveGame', { name: 'Overwatch', id: '1' }]], 'immediately sends didResolveGame');

    assert.elementCount(this.$('ul'), 0, 'list of suggested games is hidden');

    this.$('input').click();

    assert.elementCount(this.$('ul'), 1, 'list of suggested games is shown');
  });
});

test('Enter a game that does not exist', function(assert) {
  assert.expect(3);

  this.render(hbs`
    {{game-select
      gameName=null
      didBeginSearch=didBeginSearch
      didResolveGame=didResolveGame
    }}
  `);

  this.$('input').val('League').trigger('input');
  assert.deepEqual(this.callbacks, [['didBeginSearch', { name: 'League', id: null }]], 'immediately sends didBeginSearch');
  this.callbacks = [];

  return wait().then(() => {
    assert.elementCount(this.$('ul'), 0, 'No suggestions for matching games');
    assert.deepEqual(this.callbacks, [['didResolveGame', { name: 'League', id: null }]], 'later sends didResolveGame will null id');
  });
});

test('Deleting the game name', function(assert) {
  this.render(hbs`
    {{game-select
      gameName='Overwatch'
      didBeginSearch=didBeginSearch
      didResolveGame=didResolveGame
    }}
  `);

  this.$('input').val('').trigger('input');
  assert.deepEqual(this.callbacks, [['didResolveGame', { name: '', id: null }]], 'immeidately fires didResolveGame with null game');
});
