import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('game-select/game-card', 'Integration | Component | game-select/game-card');

test('Render a game card', function(assert) {
  assert.expect(4);

  let game = {
    name: 'Overwatch',
    popularity: 12345,
    box: {
      template: 'https://static-cdn.jtvnw.net/ttv-boxart/Overwatch-{width}x{height}.jpg'
    }
  };

  this.set('game', game);
  this.set('onGameSelect', () => {
    assert.ok(true, 'user can click on game card');
  });

  this.render(hbs`{{game-select/game-card game=game onGameSelect=onGameSelect}}`);

  assert.elementText(this.$('h3'), 'Overwatch', 'Game name rendered');
  assert.elementText(this.$('p'), '12,345 Viewers', 'Game popularity is commatized');
  assert.equal(this.$('img').attr('src'), 'https://static-cdn.jtvnw.net/ttv-boxart/Overwatch-26x36.jpg', 'the right image size is computed');

  this.$('a').click();
});
