import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import Ember from 'ember';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

const { helper } = Ember.Helper;

moduleForComponent('host-preview', {
  beforeEach() {
    this.set('streamStub', {
      id: 'foo-bar',
      hostHref: '/foo-bar',
      preview: {
        medium: '//blah.com/foo.jpg'
      },
      game: 'Destiny',
      gameUrl: '/game/Destiny',
      gameBoxart: '//blah.com/box-art.png',
      target: {
        viewers: 100,
        channel: {
          status: 'Flawless Trials',
          display_name: 'foo-target',
          name: 'foo-target'
        }
      }
    });

    this.routeActionInvocations = [];
    this.owner.register('helper:route-action', helper(([...args]) => {
      return (...invocationArgs) => {
        this.routeActionInvocations.push(args.concat(invocationArgs));
      };
    }));
  }
});

test('renders correct link hrefs', function (assert) {
  this.render(hbs`{{host-preview stream=streamStub}}`);

  let $channelLink = this.$('a.cap');

  assert.equal($channelLink.attr('href'), this.get('streamStub.hostHref'));
  assert.elementText('.js-channel-link', this.get('streamStub.target.channel.name'));
});

test('clicking stream thumbnail triggers route transition', function (assert) {
  this.render(hbs`{{host-preview stream=streamStub}}`);

  this.$('a.cap').click();

  let routeActionInvocation = this.routeActionInvocations[0];
  assert.equal(routeActionInvocation[0], 'handleHostClick');
  assert.equal(routeActionInvocation[1], this.get('streamStub'));
});

test('displays formatted viewer count', function (assert) {
  this.set('streamStub.target.viewers', 12345);
  this.render(hbs`{{host-preview stream=streamStub}}`);

  let infoText = this.$('.info').text().trim();
  infoText = infoText.replace(/\s+/g, ' ');

  assert.equal(infoText, '12,345 viewers on foo-target');
});
