import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('iframe-right-sidebar', 'Integration | Component | iframe right sidebar', {
  integration: true,

  beforeEach() {
    this.inject.service('layout');
  }
});

test('right column open', function (assert) {
  this.set('layout.isRightColumnClosed', false);

  this.render(hbs`{{iframe-right-sidebar}}`);

  assert.ok(this.$('.open'), 'open when right column is not closed');
});

test('right column closed', function (assert) {
  this.set('layout.isRightColumnClosed', true);

  this.render(hbs`{{iframe-right-sidebar}}`);

  assert.ok(this.$('.closed'), 'closed when right column is closed');
});
