import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import test from 'ember-sinon-qunit/test-support/test';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';

let mockInteractivityService = Service.extend({
  reportInteractive() {
  },
  reportNonInteractive() {
  }
});

moduleForComponent('interactivity-beacon', 'Integration | Component | interactivity-beacon', {
  beforeEach() {
    this.register('service:interactivity', mockInteractivityService);
    this.inject.service('interactivity');
    this.beaconTemplate = hbs('{{interactivity-beacon beaconId="myBeaconId"}}');
  }
});

test('Beacon registers itself on render', function (assert) {
  let reportInteractiveSpy = this.spy(this.get('interactivity'), 'reportInteractive');
  let reportNonInteractiveSpy = this.spy(this.get('interactivity'), 'reportNonInteractive');

  this.render(this.beaconTemplate);
  assert.ok(reportInteractiveSpy.calledOnce, 'beacon called reportInteractive on render');
  assert.equal(reportInteractiveSpy.getCalls()[0].args[0], 'beacon:myBeaconId', 'beacon called reportInteractive with the correct arguments');
  assert.notOk(reportNonInteractiveSpy.calledOnce, 'beacon has not called reportNonInteractive while rendered');

  this.clearRender();
  assert.ok(reportNonInteractiveSpy.calledOnce, 'beacon called reportNonInteractive on unrender');
  assert.equal(reportNonInteractiveSpy.getCalls()[0].args[0], 'beacon:myBeaconId', 'beacon called reportNonInteractive with the correct arguments');
});
