import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('intl/string-yield', 'Unit | Integration | intl/string-yield', {
  integration: true
});

test('Translation with Yields Are Respected', function(assert) {
  this.set('phrase', 'from {world}');
  this.set('dynamicYields', ['world']);

  this.render(hbs`
    {{~#intl/string-yield phrase dynamicYields=dynamicYields as |h|~}}
      {{~#h.section 'world'~}}
          <a href='#'>LINK</a>
      {{~/h.section~}}
    {{~/intl/string-yield~}}`);


  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'from LINK', 'Full text matches');
  assert.strictEqual($span.find('a').text(), 'LINK', 'Yielded A Tag Matches');
});

test('Confirm Missing Messages Is Not Invoked For Key', function(assert) {
  // Should not be invoked because using intl.formatMessage
  assert.expect(1);
  // Because string yield shouldn't receive a translation key
  this.register('util:intl/missing-message', function(key) {
    assert.fail('Missing messages should not be invoked');
    return key;
  });

  this.render(hbs`{{~#intl/string-yield 'made-up-key'~}}{{~/intl/string-yield~}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'made-up-key');
});
