import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('intl/t-yield', 'Unit | Integration | intl/t-yield', {
  integration: true
});

test('Error Is Thrown If Arguments are Missing For Intl T', function(assert) {
  this.set('phrase', 'Hello {world}!');

  assert.throws(() => {
    this.render(hbs`{{~#intl/t-yield (l phrase)}}{{~/intl/t-yield}}`);
  }, /A value must be provided for/);
});

test('Confirm Missing Messages is Invoked For Missing Key', function(assert) {
  assert.expect(2);
  this.register('util:intl/missing-message', function(key) {
    assert.ok('Missing Message Invoked');
    return key;
  });

  this.render(hbs`
    {{~#intl/t-yield 'made-up-key'~}}
    {{~/intl/t-yield~}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'made-up-key');
});

test('Args - Simple String', function(assert) {
  this.set('phrase', 'hello {world}!');
  this.set('args', {world: 'Pluto'});

  this.render(hbs`
    {{#intl/t-yield (l phrase) args=args}}
    {{/intl/t-yield}}`);
  
  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'hello Pluto!');
});

test('Args - Component Yield', function(assert) {
  this.set('phrase', 'hello {world}!');
  this.set('dynamicYields', ['world']);

  this.render(hbs`
    {{~#intl/t-yield (l phrase) args=(hash world=(component 'link-to' 'A Channel' 'directory.games')) as |h|~}}
      {{~#h.section~}}<a href="#">HTML WORLD</a>{{~/h.section~}}
    {{~/intl/t-yield~}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'hello A Channel!');
  assert.strictEqual($span.find('a').text(), 'A Channel');
});

test('Dynamic Yield - Arg', function(assert) {
  this.set('phrase', 'hello {world}!');
  this.set('dynamicYields', ['world']);

  this.render(hbs`
    {{~#intl/t-yield (l phrase) dynamicYields=dynamicYields as |h|~}}
      {{~#h.section 'world'}}<a href="#">HTML WORLD</a>{{~/h.section~}}
    {{~/intl/t-yield~}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'hello HTML WORLD!');
  assert.strictEqual($span.find('a').text(), 'HTML WORLD');
});

test('Dynamic Yield - XTag', function(assert) {
  this.set('phrase', 'hello <x:link>world!</x:link>');
  this.set('dynamicYields', ['x:link']);

  this.render(hbs`
    {{~#intl/t-yield (l phrase) dynamicYields=dynamicYields as |h|~}}
      {{~#h.section 'x:link' as |text|~}}<a href="#">{{text}}</a>{{~/h.section~}}
    {{~/intl/t-yield~}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'hello world!');
  assert.strictEqual($span.find('a').text(), 'world!');
});

test('Dynamic Yield - XTag - With Inner Yield', function(assert) {
  this.set('phrase', 'hello <x:link>from {world}</x:link> end');
  this.set('dynamicYields', ['x:link', 'world']);

  this.render(hbs`
    {{~#intl/t-yield (l phrase) dynamicYields=dynamicYields as |h|~}}
      {{~#h.section 'x:link' as |text|~}}
        <a href='#'>{{text}}</a>
      {{~/h.section~}}
    {{~/intl/t-yield~}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'hello from {world} end', 'Full text matches');
  assert.strictEqual($span.find('a').text(), 'from {world}', 'Yielded A Tag Matches');
});

test('Args - Multiple Args', function(assert) {
  this.set('phrase', 'hello {name} to {world}!');
  this.set('args', {name: 'Mickey', world: 'Pluto'});

  this.render(hbs`
    {{#intl/t-yield (l phrase) args=args}}
    {{/intl/t-yield}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'hello Mickey to Pluto!');
});

test('Args - Multiple Dynamic Yields', function(assert) {
  this.set('phrase', 'Welcome {name} to {world}!');
  this.set('dynamicYields', ['name', 'world']);

  this.render(hbs`
    {{#intl/t-yield (l phrase) dynamicYields=dynamicYields as |h|}}
      {{~#h.section 'name' as |text|~}}
        <a href='#'>Mickey</a>
      {{~/h.section~}}
      {{~#h.section 'world' as |text|~}}
        <a href='#'>Pluto</a>
      {{~/h.section~}}
    {{/intl/t-yield}}`);

  let $span = this.$('span').first();
  assert.strictEqual($span.text(), 'Welcome Mickey to Pluto!');
  assert.strictEqual($span.find('a').length, 2);
});


