import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { STATE_PUBLIC } from 'web-client/utilities/video/playlist';

const BUTTON_SELECTOR = '[data-test-selector="create-playlist-btn"]';
const CREATION_MENU_SELECTOR = '[data-test-selector="create-playlist-opts"]';

moduleForComponent('manager/collections/create-button', 'Integration | Component | manager/collections/create-button', {
  beforeEach() {
    this.template = hbs`
      {{manager/collections/create-button createCollectionHandler=createCollectionHandler}}
    `;
    this.render(this.template);
  }
});

test('rendering the component', function(assert) {

  assert.elementCount(BUTTON_SELECTOR, 1, 'should render the create button');
  assert.elementCount(CREATION_MENU_SELECTOR, 1, 'should render the creation menu');
});

test('creating a collection', function(assert) {
  assert.expect(3);

  let collectionTitle = 'My Title';
  let createCollectionHandler = function(collectionActionData) {
    assert.deepEqual(collectionActionData, {
      title: collectionTitle,
      state: STATE_PUBLIC
    }, 'should fire an action with the correct data');
  };

  this.set('createCollectionHandler', createCollectionHandler);

  let $menu = this.$(CREATION_MENU_SELECTOR);
  let $finalizeButton = $menu.find('[data-test-selector="finalize-playlist-btn"]');
  assert.equal($finalizeButton.attr('disabled'), 'disabled', 'button should be disabled before title is entered');

  let $titleInput = $menu.find('[type=text]');
  $titleInput.val(collectionTitle);
  $titleInput.trigger('change');

  assert.equal($finalizeButton.attr('disabled'), undefined, 'button should not be disabled after title is entered');
  $finalizeButton.click();
});
