import { skip } from 'ember-qunit';
// import Component from 'ember-component';
import hbs from 'htmlbars-inline-precompile';
import run from 'ember-runloop';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import FakeSearch from 'web-client/tests/helpers/fake-search';
import collectionScenario from 'web-client/mirage/scenarios/video-playlist';

const CONTAINER_SELECTOR = '[data-test-selector="playlist-container"]';
const ADD_VIDEOS_SELECTOR = '[data-test-selector="add-videos-btn"]';
const MODAL_SELECTOR = '[data-test-selector="modal-content"]';

moduleForComponent('manager/collections/edit-container', 'Integration | Component | manager/collections/edit-container', {
  beforeEach() {
    this.store = this.owner.lookup('service:store');
    this.owner.register('service:search', FakeSearch);
    this.inject.service('search');
    this.get('search').set('videos', []);

    let collectionPromise;
    run(() => {
      let mirageCollection = collectionScenario(this.server);
      collectionPromise = this.store.findRecord('video-playlist', mirageCollection.id).then((collection) => {
        this.collection = collection;
        this.set('collection', this.collection);

        this.template = hbs`
          {{manager/collections/edit-container
            collection=collection
            testSelector='playlist-container'
          }}

          <div id="wormhole-overlays"></div>
        `;
        this.render(this.template);
      });
    });

    return collectionPromise;
  }
});

skip('rendering the component', function(assert) {
  assert.elementCount(`h3:contains(${this.collection.get('title')})`, 1, 'should render the title');

  let itemCount = this.collection.get('items.length');

  let $container = this.$(CONTAINER_SELECTOR);
  assert.ok(
    $container.filter(`:contains(${itemCount} videos)`),
    'should render the video count'
  );
  assert.ok(
    $container.filter(`:contains(${this.collection.get('views')} views)`),
    'should render the view count'
  );
});

skip('clicking the Add Videos button', function(assert) {
  this.$(ADD_VIDEOS_SELECTOR).click();
  assert.elementCount(MODAL_SELECTOR, 1, 'should open the add video modal');
});

skip('addItemToCollection action', function(assert) {
  assert.ok(false, 'determine how to test this in integration');
});

skip('removeItemFromCollection action', function(assert) {
  assert.ok(false, 'determine how to test this in integration');
});
