import { skip } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import run from 'ember-runloop';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import collectionScenario from 'web-client/mirage/scenarios/video-playlist';

moduleForComponent('manager/collections/item-list', 'Integration | Component | manager/collections/item-list', {
  beforeEach() {
    this.mirageCollection = collectionScenario(this.server);
    this.store = this.owner.lookup('service:store');

    return run(() => {
      return this.store.findRecord('video-playlist', this.mirageCollection.id);
    }).then((collection) => {
      this.set('collection', collection);
      this.template = hbs`
        {{manager/collections/item-list collection=collection}}
      `;
      this.render(this.template);
    });
  }
});

skip('rendering the component', function(assert) {
  assert.elementCount('[data-test-selector="playlist-item-row"]', this.mirageCollection.items.length, 'should render each collection item');
});
