import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';

function generateCollections(server) {
  return [
    server.create('video-playlist', {
      title: 'foo',
      views: 1234,
      updatedAt: '2016-11-07T22:43Z'
    }),
    server.create('video-playlist', {
      title: 'bar',
      views: 2,
      updatedAt: '2016-11-10T22:43Z'
    })
  ];
}

moduleForComponent('manager/collections/list-container', 'Integration | Component | manager/collections/list-container', {
  beforeEach() {
    this.collections = generateCollections(this.server);
    this.set('collections', this.collections);

    this.template = hbs`
      {{manager/collections/list-container
        collections=collections
      }}
    `;
  }
});

test('rendering the component', function(assert) {
  this.render(this.template);

  assert.elementCount('[data-test-selector="playlist-index-row"]', this.collections.length, 'should render each collection');
});
