import { skip } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
// import playlistScenario from 'web-client/mirage/scenarios/video-playlist';
import FakeSearch from 'web-client/tests/helpers/fake-search';

const ACTIVE_TAB_CLASS = 'tabs__item--active';
// const MODAL_SELECTOR = '[data-test-selector="modal-content"]';
const CREATOR_TAB_SELECTOR = '[data-test-selector="creator-videos-tab"]';
const ALL_TAB_SELECTOR = '[data-test-selector="all-videos-tab"]';
const DONE_BTN_SELECTOR = '[data-test-selector="done-button"]';
const SEARCH_INPUT_SELECTOR = 'form__input[type=search]';
const SEARCH_CARD_SELECTOR = '[data-test-selector="search-card"]';

moduleForComponent('manager/collections/video-selector', 'Integration | Component | manager/collections/video-selector', {
  beforeEach() {
    this.doneHandlerSpy = sinon.spy();
    this.addItemToCollectionSpy = sinon.spy();
    this.removeItemFromCollection = sinon.spy();

    this.owner.register('service:search', FakeSearch);
    this.inject.service('search');

    this.set('isLoading', false);
    this.set('doneHandler', this.doneHandlerSpy);
    this.set('collectionItemIds', []);
    this.set('searchTerm', '');
    this.set('showCreatorVideos', true);

    this.template = hbs`
      {{manager/collections/video-selector
        collection=collection
        isLoading=isLoading
      }}
    `;
    this.render(this.template);
  }
});

skip('rendering the component', function(assert) {
  assert.elementHasClass(CREATOR_TAB_SELECTOR, ACTIVE_TAB_CLASS, 'creator tab should be default');
});

skip('clicking the all videos tab', function(assert) {
  assert.elementHasClass(CREATOR_TAB_SELECTOR, ACTIVE_TAB_CLASS, 'creator tab should be default');
  this.$(ALL_TAB_SELECTOR).click();

  assert.notElementHasClass(CREATOR_TAB_SELECTOR, ACTIVE_TAB_CLASS, 'creator tab should not be active');
  assert.elementHasClass(ALL_TAB_SELECTOR, ACTIVE_TAB_CLASS, 'all videos tab should be active');
});

skip('clicking the done button', function(assert) {
  this.$(DONE_BTN_SELECTOR).click();
  assert.ok(this.doneHandlerSpy.called, 'should invoke the specified done handler');
});

skip('entering a search input and clicking a card', function(assert) {
  let videoTitle = 'foo123';

  this.get('search').setProperties({ videos: [{ title: videoTitle }] });
  this.$(SEARCH_INPUT_SELECTOR).val('123');
  this.$(SEARCH_INPUT_SELECTOR).trigger('input', { target: { value: '123' }});

  return wait().then(() => {
    let $searchCards = this.$(SEARCH_CARD_SELECTOR);
    assert.equal($searchCards.length, 1, 'should show the matching search card');

    $searchCards[0].click();
    assert.ok(false, 'should');
  });
});
