import { skip } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import sinon from 'sinon';

const BUTTON_SELECTOR = '[data-test-selector="selector-button"]';

moduleForComponent('manager/collections/video-selector/button', 'Integration | Component | manager/collections/video-selector/button', {
  beforeEach() {
    this.addHandlerSpy = sinon.spy();
    this.removeHandlerSpy = sinon.spy();
    this.item = { foo: 'bar' };

    this.set('addHandler', this.addHandlerSpy);
    this.set('isAdded', false);
    this.set('isAdding', false);
    this.set('item', this.item);
    this.set('removeHandler', this.removeHandlerSpy);

    this.template = hbs`
      {{manager/collections/video-selector/button
        addHandler=addHandler
        isAdded=isAdded
        item=item
        removeHandler=removeHandler
        testSelector='selector-button'
      }}
    `;
    this.render(this.template);
  }
});

skip('rendering the component', function(assert) {
  assert.elementCount(BUTTON_SELECTOR, 1, 'should render the create button');
  // assert.elementCount(CREATION_MENU_SELECTOR, 1, 'should render the creation menu');
});

skip('clicking the Add button', function(assert) {
  assert.elementText(BUTTON_SELECTOR, 'Add', 'should be in the add state');

  this.$(BUTTON_SELECTOR).click();
  assert.ok(this.addHandlerSpy.called, 'should invoke the provided addHandler');
  assert.notOk(this.removeHandlerSpy.called, 'should not invoke the provided addHandler');
  assert.ok(this.get('isAdding'), 'should enter the pending state');
});

skip('clicking the Remove button', function(assert) {
  this.set('isAdding', true);
  this.set('isAdded', true);
  assert.notOk(this.get('isAddding'), 'should set this to false if isAdded changes to true');

  assert.elementText(BUTTON_SELECTOR, 'Remove', 'should be in the remove state');

  this.$(BUTTON_SELECTOR).click();
  assert.ok(this.addHandlerSpy.called, 'should invoke the provided addHandler');
  assert.notOk(this.removeHandlerSpy.called, 'should not invoke the provided addHandler');
});
