import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';

const OTHER_USERNAME = 'otheruser';

moduleForComponent('Integration | Component | manager/legacy-video', {
  beforeEach() {
    this.owner.register('service:login', Service.extend({
      userData: {
        login: 'username'
      }
    }));

    this.set('video', {
      channel: { name: 'username' },
      videoManagerProperties: { youtube_exporting_disabled: false }
    });
  }
});

test('Export link when user is channel owner', function(assert) {
  this.render(hbs`{{manager/legacy-video video=video}}`);
  this.$('[data-test-filter-toggle]').click();

  assert.equal(this.$('[data-test-more-actions] [data-test-export-button]').length, 1, 'shows the export button in the more list');
});

test("Export link when the user isn't the channel owner and YT export is enabled", function(assert) {
  this.set('video.channel', { name: OTHER_USERNAME });
  this.render(hbs`{{manager/legacy-video video=video}}`);
  this.$('[data-test-filter-toggle]').click();

  assert.equal(this.$('[data-test-more-actions] [data-test-export-button]').length, 1, 'shows the export button in the more list');
});

test("Export link when user isn't the channel owner and YT export disabled", function(assert) {
  this.set('video', {
    channel: { name: OTHER_USERNAME },
    videoManagerProperties: { youtube_exporting_disabled: true }
  });

  this.render(hbs`{{manager/legacy-video video=video}}`);
  this.$('[data-test-filter-toggle]').click();

  assert.equal(this.$('[data-test-more-actions] [data-test-export-button]').length, 0, 'does not show the export button in the more list');
});
