import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import { openDatepicker } from 'ember-pikaday/helpers/pikaday';
import moment from 'moment';
import EmberObject from 'ember-object';

moduleForComponent('Integration | manager/publish-strategy-selector', {
  beforeEach() {
    this.video = EmberObject.create({
      viewable: 'public',
      viewableAt: null
    });

    this.set('video', this.video);
  }
});

test("can be scheduled", function(assert) {
  assert.expect(5);

  this.render(hbs`{{manager/publish-strategy-selector video=video}}`);

  assert.equal(this.$('[data-test-publish-strategies]').val(), 'public', 'starts out as public');

  return wait().then(() => {
    this.$('[data-test-publish-strategies]').val('scheduled').trigger('change');
    this.set('video.isScheduled', true);
    return wait();
  }).then(() => {
    let interactor = openDatepicker(this.$('.pika-input')[0]);
    let todaysDate = moment();

    assert.equal(interactor.selectedYear(), todaysDate.year());
    assert.equal(interactor.selectedMonth(), todaysDate.month());
    assert.equal(interactor.selectedDay(), todaysDate.date());

    this.$('[data-test-time-picker-input]').val('1pm').change();
    assert.equal(this.$('[data-test-time-picker-input]').val(), '1:00pm', 'has the correct time');
  });
});
