import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('manager/video-upload-button', {
  beforeEach() {
    this.$().append('<div id="wormhole-overlays"></div>');
  }
});

test('starting a file upload', function(assert) {
  assert.expect(3);

  let onFileChangeArg;

  this.set('onFileChange', (arg) => {
    assert.ok(true, 'chooseFile was called');
    onFileChangeArg = arg;
  });

  this.render(hbs`{{manager/video-upload-button onFileChange=onFileChange isEmailVerified=true channelName='some-channel'}}`);

  // Trigger click to make sure we don't show the popup notice
  this.$('input').click();
  assert.equal($('#wormhole-overlays [data-test-must-verify-notice]').length, 0, 'there is no notification');

  let event = $.Event('change', { __testFiles__: ['dummy-file'] });
  this.$('input').trigger(event);

  assert.equal(onFileChangeArg, 'dummy-file', 'with the correct args');
});

test('trying to upload when user is not verified', function(assert) {
  this.render(hbs`{{manager/video-upload-button isEmailVerified=false channelName='some-channel'}}`);

  let event = $.Event('click');
  this.$('input').trigger(event);

  assert.equal($('#wormhole-overlays [data-test-must-verify-notice]').length, 1, 'shows a notification to verify');
  assert.equal(event.isDefaultPrevented(), true, 'Opening file picker was canceled');
});
