import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('manager/video-manager', 'Integration | Component | manager/video-manager', {
  beforeEach() {
    // The newer videos should be before older videos.
    // New (unsaved) videos should appear before saved videos.
    this.set('videos', [{
      title: 'first-in-progress',
      isNew: true,
      createdAt: null,
      sortByDate: null,
      isInProgress: true
    }, {
      title: 'third-in-progress',
      isNew: false,
      createdAt: new Date(2016, 1, 1),
      sortByDate: new Date(2016, 1, 1),
      isInProgress: true
    }, {
      title: 'second-in-progress',
      isNew: false,
      createdAt: new Date(2016, 1, 2),
      sortByDate: new Date(2016, 1, 2),
      isInProgress: true
    }, {
      title: 'first-complete',
      isNew: false,
      createdAt: new Date(2016, 1, 3),
      sortByDate: new Date(2016, 1, 3),
      recordedDate: new Date(2016, 1, 3),
      isProcessed: true
    }, {
      title: 'third-complete',
      isNew: false,
      createdAt: new Date(2016, 1, 1),
      sortByDate: new Date(2016, 1, 1),
      recordedDate: new Date(2016, 1, 1),
      isProcessed: true
    }, {
      title: 'second-complete',
      isNew: false,
      createdAt: new Date(2016, 1, 2),
      sortByDate: new Date(2016, 1, 2),
      recordedDate: new Date(2016, 1, 2),
      isProcessed: true
    }]);
  }
});

test('it yields sorted and filtered videos', function(assert) {
  this.render(hbs`
    {{#manager/video-manager videos=videos as |videoUploads|}}
      {{#each videoUploads.inProgressVideos as |video|}}
        <div class="in-progress">{{video.title}}</div>
      {{/each}}

      {{#each videoUploads.publishedVideos as |video|}}
        <div class="complete">{{video.title}}</div>
      {{/each}}
    {{/manager/video-manager}}
  `);

  assert.deepEqual(
    extractText(this.$('.in-progress')),
    ['first-in-progress', 'second-in-progress', 'third-in-progress'],
    "sorts and filters in-progress videos"
  );

  assert.deepEqual(
    extractText(this.$('.complete')),
    ['first-complete', 'second-complete', 'third-complete'],
    "sorts and filters complete videos"
  );
});

function extractText(jqElements) {
  return jqElements.toArray().map((el) => el.textContent);
}
