import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('navigation-search/results-section', {
  beforeEach() {
    this.set('onHeaderClick', () => {});
    this.set('category', {});

    this.render(
      hbs`{{navigation-search/results-section
        category=category
        onHeaderClick=onHeaderClick
      }}`
    );
  }
});

test('it shows More when there are top results', function(assert) {
  this.set('category', { hitCount: 1, totalHitCount: 1 });

  assert.equal(this.$('.search-result-view__title-more').text().trim(), 'More');
});

test('it shows Show when there are no top results', function(assert) {
  this.set('category', { hitCount: 0, totalHitCount: 1 });

  assert.equal(this.$('.search-result-view__title-more').text().trim(), 'Show');
});

test('it has no message when there are no results', function(assert) {
  this.set('category', { hitCount: 0, totalHitCount: 0 });

  assert.equal(this.$('.search-result-view__title-more').text().trim(), '');
});
