/* globals Twitch */
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import test from 'ember-sinon-qunit/test-support/test';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('notification-banner', 'Integration | Component | notification banner', {
  integration: true
});

test('it does nothing in supported browser', function (assert) {
  let stub = this.stub(Twitch.notify, 'notice');

  this.render(hbs`{{notification-banner}}`);

  assert.ok(!stub.calledOnce, 'notice was not called');
});

test('it renders notification in unsupported browser', function (assert) {
  let stub = this.stub(Twitch.notify, 'notice');

  this.inject.service('globals');
  this.globals.set('isIE9OrLess', true);

  this.render(hbs`{{notification-banner}}`);

  assert.ok(stub.calledOnce, 'notice was called');

  let { args } = stub.firstCall;
  assert.equal(typeof(args[0]), 'string', 'message passed to notice');
});
