import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import wait from 'ember-test-helpers/wait';

moduleForComponent('notification-controls', {
  integration: true,
  beforeEach() {
    stubLogin({ login: 'twitch' });
    this.server.create('user', { notifications: { push: true } });
    this.channel = this.server.create('channel', { id: 'day9tv', name: 'day9tv' });
    this.set('day9tv', { id: 'day9tv' });
    this.defaultTemplate = hbs`{{notification-controls name='profile' channel=day9tv}}`;
  }
});

test('hidden by default when user has no push notifications', function(assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount(this.$('.notification-controls[style="display: none;"]'), 1, 'component rendered hidden');
  });
});

test('show notification balloon on profile card', function(assert) {
  assert.expect(3);
  this.server.create('follow', { userName: 'twitch', channelName: 'day9tv', channel: this.channel });

  this.render(this.defaultTemplate);

  let $card = this.$('.profile-card').first();

  assert.ok($card.find('.balloon.hide'), 'balloon is hidden by default');

  $card.mouseover();
  $card.find('.notification-controls button').click();
  assert.ok($card.find('.balloon.hide'), 'balloon is shown on click');

  // Mouse out of the card
  $card.mouseout();
  assert.ok($card.find('.balloon.hide'), 'balloon is hidden on mouse out');
});

test('user with push notifications; followed channel; can enable', function(assert) {
  assert.expect(3);

  this.server.create('follow', { userName: 'twitch', channelName: 'day9tv', channel: this.channel });

  this.render(this.defaultTemplate);

  return wait().then(() => {
    this.$('a.toggle-notification-menu.js-toggle-notification-menu').click();
    return wait();
  }).then(() => {
    let $switch = this.$('.notification-controls a.switch.disabled');
    assert.ok($switch.length, 'switch is visible and off');
    $switch.click();
    return wait();
  }).then(() => {
    let $switch = this.$('.notification-controls a.switch.active');
    assert.ok($switch.length, 'switch changed to active');

    let follow = this.server.schema.follows.where({ channelName: 'day9tv' }).models[0];
    assert.strictEqual(follow.attrs.notifications, true, 'notifications set to true via API');
  });
});

test('user with push notifications; followed channel; can disable', function(assert) {
  assert.expect(3);

  this.server.create('follow', { userName: 'twitch', channelName: 'day9tv', channel: this.channel, notifications: true });

  this.render(this.defaultTemplate);

  return wait().then(() => {
    this.$('a.toggle-notification-menu.js-toggle-notification-menu').click();
    return wait();
  }).then(() => {
    let $switch = this.$('.notification-controls a.switch.active');
    assert.ok($switch.length, 'switch is visible and active');
    $switch.click();
    return wait();
  }).then(() => {
    let $switch = this.$('.notification-controls a.switch.disabled');
    assert.ok($switch.length, 'switch changed to disabled');

    let follow = this.server.schema.follows.where({ channelName: 'day9tv' }).models[0];
    assert.strictEqual(follow.attrs.notifications, false, 'notifications set to false via API');

  });
});
