import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('progress-bar');

test('renders an inner bar based on current and total values', function(assert) {
  this.render(hbs`{{progress-bar current=20 total=100}}`);

  assert.equal(this.$('.progress-bar__fill')[0].style.width, '20%', 'uses the correct width');
});

test('shows no progress when given undefined values', function(assert) {
  this.render(hbs`{{progress-bar}}`);

  assert.equal(this.$('.progress-bar__fill')[0].style.width, '0%', 'uses the correct width');
});

test('works with numeric string values', function(assert) {
  this.render(hbs`{{progress-bar current='20' total='100'}}`);

  assert.equal(this.$('.progress-bar__fill')[0].style.width, '20%', 'uses the correct width');
});

test('shows no progress with non-numeric string values', function(assert) {
  this.render(hbs`{{progress-bar current='getting-there' total='all-of-it'}}`);

  assert.equal(this.$('.progress-bar__fill')[0].style.width, '0%', 'uses the correct width');
});
