import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('progress-bar/countdown', 'Integration | Component | progress bar/countdown', {
  beforeEach() {
    this.size = 'D';
    this.duration = 0;
    this.on('completedAction', () => {});

    this.defaultTemplate = hbs`
      {{progress-bar/countdown
        size=size
        duration=duration
        completedAction=(action 'completedAction')}}
    `;
  }
});

test('default size, no duration', function (assert) {
  assert.expect(3);

  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount('.progress-bar.progress-bar--countdown', 1, 'Has base classes');
    assert.elementCount('.progress-bar--sm', 0, `Doesn't have '--sm' modifier`);
    assert.elementCount('.progress-bar--xs', 0, `Doesn't have '--xs' modifier`);
  });
});

test('small size', function (assert) {
  assert.expect(3);

  this.size = 'small';
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount('.progress-bar.progress-bar--countdown', 1, 'Has base classes');
    assert.elementCount('.progress-bar--sm', 1, `Has '--sm' modifier`);
    assert.elementCount('.progress-bar--xs', 0, `Doesn't have '--xs' modifier`);
  });
});

test('extra-small size', function (assert) {
  assert.expect(3);

  this.size = 'extraSmall';
  this.render(this.defaultTemplate);

  return wait().then(() => {
    assert.elementCount('.progress-bar.progress-bar--countdown', 1, 'Has base classes');
    assert.elementCount('.progress-bar--xs', 1, `Has '--xs' modifier`);
    assert.elementCount('.progress-bar--sm', 0, `Doesn't have '--sm' modifier`);
  });
});

test('completedAction is invoked', function (assert) {
  assert.expect(1);

  this.duration = 1;
  this.on('completedAction', () => {
    assert.ok(true, 'completedAction triggered');
  });
  this.render(this.defaultTemplate);

  return wait();
});
