import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import run from 'ember-runloop';

moduleForComponent('require-scroll', 'Integration | Component | require scroll', {
  integration: true
});

test('it yields hasScrolledToBottom', function(assert) {
  assert.expect(3);

  this.render(hbs`
    {{#require-scroll
      windowSelector=".window"
      contentSelector=".wrapper"
      as |hasScrolledToBottom|}}

      <div class="window" style="width: 250px; height: 200px; overflow-y: scroll;">
        <div style="position: absolute; z-index: 2; color: white">
          has scrolled: {{hasScrolledToBottom}}
        </div>

      <div class="wrapper" style="width: 200px; height: 800px; position: relative; background-color: red;">
      </div>
    </div>

    {{/require-scroll}}
  `);

  assert.equal(this.$().text().trim(), 'has scrolled: false', 'initially false');

  run(() => {
    this.$('.window').scrollTop(50);
    this.$('.window').trigger('scroll');

    assert.equal(this.$().text().trim(), 'has scrolled: false', 'still false when partially scrolled');

    this.$('.window').scrollTop(9000);
    this.$('.window').trigger('scroll');

    assert.equal(this.$().text().trim(), 'has scrolled: true', 'true once bottom is reached');
  });
});
