import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('saving-button', 'Integration | Component | saving button');

test('isSaving disables saving button when true', function (assert) {
  assert.expect(1);

  this.set('saveAction', () => { assert.ok(false); });
  this.set('isSaving', true);
  this.render(hbs`{{saving-button isSaving=isSaving save=(action saveAction)}}`);
  assert.equal(this.$('button').attr('disabled'), 'disabled');

  this.$('button').click();
});

test('Calls save action on click', function (assert) {
  assert.expect(1);

  this.set('saveAction', () => { assert.ok(true); });
  this.render(hbs`{{saving-button save=(action saveAction)}}`);

  this.$('button').click();
});
