import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { test } from 'ember-qunit';

moduleForComponent('separated-list');

test('it lists each element correctly separated', function (assert) {
  assert.expect(1);
  this.set('items', [1,2,3,4]);
  this.render(hbs`{{#separated-list items=items as |item|}}{{item}}{{/separated-list}}`);
  assert.equal(this.$().text(), this.get('items').join(', '));
});

test('it uses the correct separator', function (assert) {
  assert.expect(1);
  this.set('items', [1,2,3,4]);
  this.set('separator', '|');
  this.render(hbs`{{#separated-list items=items separator=separator as |item|}}{{item}}{{/separated-list}}`);
  assert.equal(this.$().text(), this.get('items').join('| '));
});
