import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

const EXTENSION_HEADER_SELECTOR = '[data-test-selector="ext-name"]';
const EXTENSION_AUTHOR_SELECTOR = '[data-test-selector="ext-author"]';
const EXTENSION_ICON_SELECTOR = '[data-test-selector="ext-icon"]';
const EXTENSION_CONFIG_ELEMENT_SELECTOR = '[data-test-selector="ext-config-frame"]';

moduleForComponent('settings/extension-config', 'Integration | Component | settings/extension-config', {
  integration: true
});

test('it renders', function(assert) {
  assert.expect(5);

  let extension = Object.create({
    name: 'Test Extension',
    authorName: 'Extension Author',
    summary: 'This is a test extension',
    iconUrl: 'http://placehold.it/50x50',
    configUrl: 'http://example.com/config.html'
  });

  this.set('extension', extension);
  this.render(hbs`
    {{settings/extension-config
      extension=extension
    }}
  `);

  return wait().then(() => {
    assert.equal(this.$(EXTENSION_HEADER_SELECTOR).text(), 'Test Extension');
    assert.equal(this.$(EXTENSION_AUTHOR_SELECTOR).text(), 'Created by Extension Author');
    assert.equal(this.$(EXTENSION_ICON_SELECTOR).attr('src'), 'http://placehold.it/50x50');

    let configElement = this.$(EXTENSION_CONFIG_ELEMENT_SELECTOR);
    assert.equal(configElement.attr('src'), 'http://example.com/config.html');
    assert.ok(configElement.is('iframe'));
  });
});
