import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

const EXTENSION_HEADER_SELECTOR = '[data-test-selector="ext-name"]';
const EXTENSION_AUTHOR_SELECTOR = '[data-test-selector="ext-author"]';
const EXTENSION_ICON_SELECTOR = '[data-test-selector="ext-icon"]';
const EXTENSION_SCREENS_SELECTOR = '[data-test-selector="ext-screens"] img';
const INSTALL_BUTTON_SELECTOR = '[data-test-selector="ext-install"]';

moduleForComponent('settings/extension-details', 'Integration | Component | settings/extension-details', {
  integration: true
});

test('it renders', function(assert) {
  assert.expect(7);

  let screenshotUrls = [
    'http://placehold.it/320x480?text=Image+1',
    'http://placehold.it/320x480?text=Image+2',
    'http://placehold.it/320x480?text=Image+3'
  ];

  let extension = Object.create({
    name: 'Test Extension',
    authorName: 'Extension Author',
    summary: 'This is a test extension',
    iconUrl: 'http://placehold.it/50x50',
    screenshotUrls
  });

  this.set('extension', extension);
  this.on('installExtension', () => {
    assert.ok(true, 'installExtension action triggered');
  });

  this.render(hbs`
    {{settings/extension-details
      extension=extension
      installExtension=(action 'installExtension')
    }}`);

  return wait().then(() => {
    assert.equal(this.$(EXTENSION_HEADER_SELECTOR).text(), 'Test Extension');
    assert.equal(this.$(EXTENSION_AUTHOR_SELECTOR).text(), 'Created by Extension Author');
    assert.equal(this.$(EXTENSION_ICON_SELECTOR).attr('src'), 'http://placehold.it/50x50');

    let imageElements = this.$(EXTENSION_SCREENS_SELECTOR);
    screenshotUrls.forEach((img, index) => {
      assert.equal(imageElements.eq(index).attr('src'), img);
    });

    this.$(INSTALL_BUTTON_SELECTOR).click();
  });
});
