import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';

const TEST_EXTENSION_ID = 'SOME_EXT';
const TEST_EXTENSION_NAME = 'My Extension';

const MODAL_HEADER_SELECTOR = '[data-test-selector=ext-modal-header]';
const MODAL_NAME_SELECTOR = '[data-test-selector=ext-modal-name]';
const MODAL_CANCEL_BUTTON_SELECTOR = '[data-test-selector=ext-modal-cancel]';
const MODAL_PROCEED_BUTTON_SELECTOR = '[data-test-selector=ext-modal-proceed]';

moduleForComponent('settings/extension-dialogs', 'Integration | Component | settings/extension-dialogs', {
  integration: true,

  beforeEach() {
    this.onProceed = sinon.spy();
    this.onCancel = sinon.spy();

    this.testExtension = {
      id: TEST_EXTENSION_ID,
      name: TEST_EXTENSION_NAME
    };

    this.set('installedExtension', null);
    this.set('extensionToUninstall', null);
    this.set('onProceed', this.onProceed);
    this.set('onCancel', this.onCancel);

    this.render(hbs`{{settings/extension-dialogs
      onProceed=onProceed
      onCancel=onCancel
      installedExtension=installedExtension
      extensionToUninstall=extensionToUninstall
      renderInPlace=true
    }}`);
  }
});

test('when installed extension is set', function(assert) {
  this.set('installedExtension', this.testExtension);

  assert.equal(this.$(MODAL_HEADER_SELECTOR).text().trim(), 'Extension Installed Successfully!', 'expected header text is shown');

  this.$(MODAL_CANCEL_BUTTON_SELECTOR).click();
  assert.ok(this.onCancel.called, 'when cancel button is clicked, onCancel callback is called');

  this.set('installedExtension', this.testExtension);

  this.$(MODAL_PROCEED_BUTTON_SELECTOR).click();
  assert.notOk(this.onProceed.called, 'when proceed button is clicked, onProceed callback is not called');
});


test('when extension to uninstall is set', function(assert) {
  this.set('extensionToUninstall', { extension: this.testExtension });

  assert.equal(this.$(MODAL_HEADER_SELECTOR).text().trim(), 'Are you sure you want to Uninstall?', 'expected header text is shown');
  assert.equal(this.$(MODAL_NAME_SELECTOR).text().trim(), TEST_EXTENSION_NAME, 'extension name is shown');

  this.$(MODAL_CANCEL_BUTTON_SELECTOR).click();
  assert.ok(this.onCancel.called, 'when cancel button is clicked, onCancel callback is called');

  this.set('extensionToUninstall', { extension: this.testExtension });

  this.$(MODAL_PROCEED_BUTTON_SELECTOR).click();
  assert.ok(this.onProceed.called, 'when proceed button is clicked, onProceed callback is called');
});
