import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

const AVAILABLE_CARD_NAME_SELECTOR = '[data-test-selector="ext-available-name"]';
const AVAILABLE_CARD_AUTHOR_SELECTOR = '[data-test-selector="ext-available-author"]';
const AVAILABLE_CARD_SUMMARY_SELECTOR = '[data-test-selector="ext-available-summary"]';
const AVAILABLE_CARD_INSTALL_SELECTOR = '[data-test-selector="ext-available-install"]';

moduleForComponent('settings/extension-manager/available-card', 'Integration | Component | settings/extension-manager/available-card', {
  integration: true
});

test('it renders', function(assert) {
  assert.expect(4);

  this.set('extension', {
    name: 'Test Extension',
    author: 'Extension Author',
    summary: 'This is a test extension'
  });

  this.on('onInstallClicked', function() {
    assert.ok(true, '');
  });

  this.render(hbs`
    {{settings/extension-manager/available-card
      extension=extension
      installExtension=(action 'onInstallClicked')
    }}`);

  return wait().then(() => {
    assert.equal(this.$(AVAILABLE_CARD_NAME_SELECTOR).text(), 'Test Extension');
    assert.equal(this.$(AVAILABLE_CARD_AUTHOR_SELECTOR).text(), 'by Extension Author');
    assert.equal(this.$(AVAILABLE_CARD_SUMMARY_SELECTOR).text(), 'This is a test extension');

    this.$(AVAILABLE_CARD_INSTALL_SELECTOR).click();
  });

});
