import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import Object from 'ember-object';

const INSTALLED_EXTENSIONS_LIST_SELECTOR = '[data-test-selector="ext-installed-list"] > p';
const AVAILABLE_EXTENSIONS_LIST_SELECTOR = '[data-test-selector="ext-available-list"] > p';

moduleForComponent('settings/extension-manager', 'Integration | Component | settings/extension-manager', {
  integration: true,
  beforeEach() {
    let extensions = [1, 2, 3, 4, 5, 6].map(id => {
      return Object.create({
        id,
        name: `Test Extension ${id}`,
        authorName: 'Extension Author',
        summary: 'This is a test extension'
      });
    });

    let installedExtensions = extensions.filter(ext => ext.id % 2 === 0).map(extension => {
      return Object.create({
        extension
      });
    });

    this.set('allExtensions', extensions);
    this.set('installedExtensions', installedExtensions);
  }
});

test('"No installed extensions" message is visible if installedExtensions is empty', function(assert) {
  this.render(hbs`{{settings/extension-manager
    allExtensions=allExtensions
  }}`);

  assert.equal(this.$(INSTALLED_EXTENSIONS_LIST_SELECTOR).length, 1);
});

test('"No installed extensions" message is not visible if installedExtensions is not empty', function(assert) {
  this.render(hbs`{{settings/extension-manager
    allExtensions=allExtensions
    installedExtensions=installedExtensions
  }}`);

  assert.equal(this.$(INSTALLED_EXTENSIONS_LIST_SELECTOR).length, 0);
});

test('"No available extensions" message is visible if availableExtensions is empty', function(assert) {
  this.render(hbs`{{settings/extension-manager}}`);

  assert.equal(this.$(AVAILABLE_EXTENSIONS_LIST_SELECTOR).length, 1);
});

test('"No available extensions" message is not visible if availableExtensions is not empty', function(assert) {
  this.render(hbs`{{settings/extension-manager
    allExtensions=allExtensions
  }}`);

  assert.equal(this.$(AVAILABLE_EXTENSIONS_LIST_SELECTOR).length, 0);
});
