import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Object from 'ember-object';
import wait from 'ember-test-helpers/wait';

const INSTALLED_CARD_NAME_SELECTOR = '[data-test-selector="ext-installed-name"]';
const INSTALLED_CARD_ICON_SELECTOR = '[data-test-selector="ext-installed-icon"]';
const INSTALLED_CARD_UNINSTALL_SELECTOR = '[data-test-selector="ext-installed-uninstall"]';

moduleForComponent('settings/extension-manager/installed-card', 'Integration | Component | settings/extension-manager/installed-card', {
  integration: true
});

test('it renders', function(assert) {
  assert.expect(3);

  let extension = Object.create({
    name: 'Test Extension',
    author: 'Extension Author',
    summary: 'This is a test extension',
    iconUrl: 'http://lorempixel.com/50/50/abstract/'
  });

  let installedExtension = Object.create({
    extension
  });

  this.set('installedExtension', installedExtension);
  this.on('uninstallExtension', () => {
    assert.ok(true, 'uninstallExtension action triggered');
  });

  this.render(hbs`
    {{settings/extension-manager/installed-card
      installedExtension=installedExtension
      uninstallExtension=(action 'uninstallExtension')
    }}`);

  return wait().then(() => {
    assert.equal(this.$(INSTALLED_CARD_NAME_SELECTOR).text(), 'Test Extension');
    assert.equal(this.$(INSTALLED_CARD_ICON_SELECTOR).attr('src'), 'http://lorempixel.com/50/50/abstract/');

    this.$(INSTALLED_CARD_UNINSTALL_SELECTOR).click();
  });
});
