import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import {
  facebookShareLink,
  twitterShareLink,
  redditShareLink,
  vkShareLink
} from 'web-client/utilities/social-links';

const SPECIAL_CHARACTERS = 'this should be encoded!@#$%^&*()\'{}|\\';

moduleForComponent('share-box', 'Integration | Component | share-box');

test('clicking on the button opens the menu', function(assert) {
  this.render(hbs`
    {{share-box
      content=channel
      type="channel"
      label="Share"
    }}`);

  assert.notOk(this.$('.js-share-box .js-balloon').hasClass('show'));
  assert.ok(this.$('.js-share-box .js-balloon').hasClass('hide'));
  this.$('.js-share-box button').click();
  assert.ok(this.$('.js-share-box .js-balloon').hasClass('show'));
  assert.notOk(this.$('.js-share-box .js-balloon').hasClass('hide'));
});

testLinks(
  'music errday',
  'music errday',
  'uses channel status to create share links for live channels'
);

testLinks(
  'earth music',
  'earth music',
  'uses vod title to create share links for vods'
);

testLinks(
  SPECIAL_CHARACTERS,
  SPECIAL_CHARACTERS,
  'share links encodes all special characters'
);

testLinks(
  '',
  '',
  'share links are created with empty strings if text is empty'
);

testLinks(
  null,
  '',
  'share links are created with empty strings if is set to null'
);

function testLinks(assertion, expectation, message) {
  test('Building share links for live', function(assert) {
    assert.expect(4);

    this.set('channel', {
      status: assertion,
      id: 'monstercat'
    });

    this.url = 'https://www.twitch.tv/monstercat';

    this.render(hbs`
      {{share-box
        content=channel
        type='channel'
        label='Share'
      }}`);
    linkAssertions.call(this, assert, expectation, message);
  });

  test('Building share links for vod', function(assert) {
    assert.expect(4);

    this.set('vod', {
      title: assertion,
      url: 'https://www.twitch.tv/monstercat/v/1234'
    });

    this.render(hbs`
      {{share-box
        content=vod
        type='video'
        label='Share'
      }}`);

    linkAssertions.call(this, assert, expectation, message);
  });
}

function linkAssertions(assert, expectation, message) {
  if (this.get('vod.url')) {
    this.url = this.get('vod.url');
  }

  assert.equal(this.$('.js-share-icons .js-twitter').attr('href'), twitterShareLink(this.url, expectation), message);
  assert.equal(this.$('.js-share-icons .js-fb').attr('href'), facebookShareLink(this.url), message);
  assert.equal(this.$('.js-share-icons .js-vk').attr('href'), vkShareLink(this.url), message);
  assert.equal(this.$('.js-share-icons .js-reddit').attr('href'), redditShareLink(this.url, expectation), message);
}
