import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('show-iframe', 'Integration | Component | show iframe', {
  integration: true
});

test('it renders', function(assert) {
  // Set any properties with this.set('myProperty', 'value');
  // Handle any actions with this.on('myAction', function(val) { ... });

  this.render(hbs`{{show-iframe}}`);

  assert.equal(this.$().text().trim(), '');
});

test('has expected values', function(assert) {
  this.set('url', 'test.url');
  this.set('height', '123px');
  this.set('width', '321px');
  this.set('style', 'hidden');
  this.set('id', 'test-id');

  this.render(hbs`{{show-iframe url=url height=height width=width style=style id=id}}`);

  assert.equal(this.$('iframe').length, 1);
  assert.equal(this.$('iframe').attr('src').trim(), 'test.url');
  assert.equal(this.$('iframe').attr('id').trim(), 'test-id-iframe');
  assert.equal(this.$('iframe').attr('height').trim(), '123px');
  assert.equal(this.$('iframe').attr('width').trim(), '321px');
  assert.equal(this.$('iframe').attr('style').trim(), 'hidden');
});
