import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

const SORT_TITLE_SELECTOR = '.js-sort-control';
const OPTIONS_SELECTOR = '.js-sort-options li:visible';
const SOMETHING_ELSE_SELECTOR = '.something-else';

const STANDARD_TEMPLATE = hbs`
  <div class="something-else"></div>

  {{#sort-control selected=currentDisplayTitle}}
    <li>Viewers</li>
    <li>Skill</li>
  {{/sort-control}}
`;

moduleForComponent('sort-control', {
  beforeEach() {
    this.set('currentDisplayTitle', 'Viewers');
  }
});

test('it displays selected', function (assert) {
  this.render(STANDARD_TEMPLATE);

  assert.equal(this.$(SORT_TITLE_SELECTOR).text().trim(), 'Viewers');
});

test('it shows the block content when clicked', function (assert) {
  this.render(STANDARD_TEMPLATE);

  this.$(SORT_TITLE_SELECTOR).click();

  let options = this.$(OPTIONS_SELECTOR);

  assert.equal(options.length, 2);
  assert.equal(options[0].textContent, 'Viewers');
  assert.equal(options[1].textContent, 'Skill');
});

test('it hides the block content when clicked away', function (assert) {
  let options;
  this.render(STANDARD_TEMPLATE);

  this.$(SORT_TITLE_SELECTOR).click();

  options = this.$(OPTIONS_SELECTOR);
  assert.equal(options.length, 2, 'precond - shows items');

  this.$(SOMETHING_ELSE_SELECTOR).click();

  options = this.$(OPTIONS_SELECTOR);
  assert.equal(options.length, 0, 'items are hidden');
});
