/* globals i18n */
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import ArrayProxy from 'ember-controller/proxy';
import Component from 'ember-component';

let MockCollection = ArrayProxy.extend({
  isLoading: false,
  loadMore() { return this; }
});

const STREAM_SELECTOR = '.stream';

moduleForComponent('stream-list', {
  beforeEach() {
    this.owner.register('component:infinite-scroll', Component.extend({
      init() {
        this._super(...arguments);
        this.sendAction();
      }
    }));

    this.owner.register('template:component/infinite-scroll', hbs`{{yield}}`);
  }
});

test('it passes all streams to child content', function (assert) {
  assert.expect(1);
  this.set('streams', MockCollection.create({ content: [0, 1, 2] }));
  this.render(hbs`{{#stream-list streams=streams as |items|}}<span class="stream">{{items.length}}</span>{{/stream-list}}`);
  assert.equal(this.$(STREAM_SELECTOR).text(), 3);
});

test('it calls loadMore when more content is required', function (assert) {
  assert.expect(1);
  let streams = MockCollection.create({
    loadMore() { assert.ok(true); }
  });
  this.set('streams', streams);
  this.render(hbs`{{stream-list streams=streams}}`);
});

test('it renders loading spinner', function(assert) {
  this.set('streams', MockCollection.create({ isLoading: true}));
  this.render(hbs`{{#stream-list streams=streams}}<span class="stream"></span>{{/stream-list}}`);

  assert.ok(this.$('.loading-spinner').length, 'shows loading spinner');
});

test('it renders default empty message', function(assert) {
  this.set('streams', MockCollection.create());
  this.render(hbs`{{#stream-list streams=streams}}<span class="stream"></span>{{/stream-list}}`);

  assert.equal(this.$(`p.empty-grid`).text().trim(), i18n('No Channels Live'), 'shows default empty message');
});

test('it renders custom empty message', function(assert) {
  let emptyMessage = 'No values 0000';
  this.set('emptyMessage', emptyMessage);

  this.set('streams', MockCollection.create());
  this.render(hbs`{{#stream-list streams=streams emptyMessage=emptyMessage}}<span class="stream"></span>{{/stream-list}}`);

  assert.equal(this.$(`p.empty-grid`).text().trim(), emptyMessage, 'shows custom empty message');
});

test('it calls customized loadMore', function(assert) {
  assert.expect(1);
  this.set('streams', MockCollection.create({
    loadMore() {
      assert.notOk(true, 'should not be called');
    }
  }));

  this.on('customizedLoadMore', function() {
    assert.ok(true, 'custom loadMore function called');
  });

  this.render(hbs`{{#stream-list streams=streams loadMore=(action 'customizedLoadMore')}}<span class="stream"></span>{{/stream-list}}`);
});
