import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('stream-preview', {
  beforeEach() {
    this.set('fakeStream', {
      id: 'foo-bar',
      channelHref: '/foo-bar',
      preview: {
        medium: '//blah.com/foo.jpg'
      },
      game: 'Destiny',
      gameUrl: '/game/Destiny',
      gameBoxart: '//blah.com/box-art.png',
      channel: {
        status: 'Flawless Trials',
        display_name: 'foo-bar'
      },
      viewers: 100
    });

    let routeActionInvocations = this.routeActionInvocations = [];
    this.owner.register('router:main', {
      create() {
        return {
          send(...args) {
            routeActionInvocations.push(args);
          }
        };
      }
    });
  }
});

test('clicking stream thumbnail triggers route transition', function (assert) {
  this.render(hbs`{{stream-preview stream=fakeStream}}`);

  this.$('a.cap').click();

  let routeActionInvocation = this.routeActionInvocations[0];
  assert.equal(routeActionInvocation[0], 'handleStreamClick');
  assert.equal(routeActionInvocation[1], this.get('fakeStream'));
});

test('clicking stream thumbnail triggers route transition', function (assert) {
  this.render(hbs`{{stream-preview stream=fakeStream}}`);

  this.$('a.cap').click();

  let routeActionInvocation = this.routeActionInvocations[0];
  assert.equal(routeActionInvocation[0], 'handleStreamClick');
  assert.equal(routeActionInvocation[1], this.get('fakeStream'));
});

test('displays formatted viewer count', function (assert) {
  this.set('fakeStream.viewers', 12345);
  this.render(hbs`{{stream-preview stream=fakeStream}}`);

  let infoText = this.$('.info').text().trim();
  infoText = infoText.replace(/\s+/g, ' ');

  assert.equal(infoText, '12,345 viewers on foo-bar');
});

test('displays stream status when present', function (assert) {
  this.set('fakeStream.channel.status', 'Do EEEEETTT!!');
  this.render(hbs`{{stream-preview stream=fakeStream}}`);

  let titleText = this.$('.title').text().trim();

  assert.equal(titleText, this.get('fakeStream.channel.status'));
});

test('displays tags when showTags is true', function (assert) {
  this.set('fakeStream.tags', [{ tag: 'gamedev', id: 'gamedev' }, { tag: 'programming', id: 'programming' }]);
  this.set('showTags', true);
  this.render(hbs`{{stream-preview stream=fakeStream showTags=showTags}}`);

  assert.equal(this.$('.ct-tag').length, 0);
});

test('does not display tags when showTags is false', function (assert) {
  this.set('fakeStream.tags', [{ tag: 'gamedev', id: 'gamedev' }, { tag: 'programming', id: 'programming' }]);
  this.set('showTags', false);
  this.render(hbs`{{stream-preview stream=fakeStream showTags=showTags}}`);

  assert.equal(this.$('.ct-tag').length, 0);
});

test('does not display tags when showTags is not provided', function (assert) {
  this.set('fakeStream.tags', [{ tag: 'gamedev', id: 'gamedev' }, { tag: 'programming', id: 'programming' }]);
  this.render(hbs`{{stream-preview stream=fakeStream}}`);

  assert.equal(this.$('.ct-tag').length, 0);
});
